// Function to generate a pseudo-random number based on a seed
function seededRandom(seed) {
  var x = Math.sin(seed) * 10000;
  return x - Math.floor(x);
}

// Function to add a circle to the circles container
function addCircle(container, imagePath, size, seed) {
  const circle = document.createElement("img");
  circle.src = imagePath;
  circle.classList.add("circles");

  const randomX = seededRandom(seed) * (window.innerWidth - size);
  const randomY = seededRandom(seed + 1) * (window.innerHeight - size);

  circle.style.left = randomX + "px";
  circle.style.top = randomY + "px";
  circle.style.width = size + "px";
  circle.style.height = size + "px";

  container.appendChild(circle);
}

// Constants
const numInstances = 50; // Number of circle instances
const imageSizeRange = [400, 700]; // Range of image sizes

// Seed for repeatable randomness
const seed = 42;

// Get the circles container
const circlesContainer = document.getElementById("circles-container");

// Add multiple instances of circles to the container
for (let i = 0; i < numInstances; i++) {
  const randomImageIndex = Math.floor(seededRandom(seed + i) * 3) + 1;
  const imagePath = `blur${randomImageIndex}.png`;
  const imageSize = Math.floor(seededRandom(seed + i + 1) * (imageSizeRange[1] - imageSizeRange[0])) + imageSizeRange[0];
  addCircle(circlesContainer, imagePath, imageSize, seed + i + 2);
}
